clear
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/fullvars_stack.dta"
*ssc install egenmore 

gen month = month(date)
gen day = day(date) 
gen quarter = quarter(date) 
drop if year < 2002 

by name year quarter, sort: egen lev_avg=mean(lev)
by name year quarter, sort: egen tierone_avg=mean(tierone)
by name year quarter, sort: egen tce_avg=mean(tce)

*** first part of Baker Wurgler is showing that there is a relationship between beta and leverage 
*** quintiles by leverage 
egen quant_lev = xtile(lev_avg), n(5) by(year quarter) 
egen quant_tierone = xtile(tierone_avg), n(5) by(year month) 
egen quant_tce = xtile(tce_avg), n(5) by(year month) 

*** we also want to calculate avg beta and vol in each quintile group 
**tier1
by quant_lev, sort: egen beta_by_lev=mean(beta)
by quant_lev, sort: egen vol_by_lev=mean(vol)
by quant_lev, sort: egen impvol_by_lev=mean(impvol)

by quant_tierone, sort: egen beta_by_tierone=mean(beta)
by quant_tierone, sort: egen vol_by_tierone=mean(vol)
by quant_tierone, sort: egen impvol_by_tierone=mean(impvol)

by quant_tce, sort: egen beta_by_tce=mean(beta)
by quant_tce, sort: egen vol_by_tce=mean(vol)
by quant_tce, sort: egen impvol_by_tce=mean(impvol)

*** display for betas, vol, impvol 
**** first for quintile sort by leverage
drop if quant_lev == .
preserve 
by quant_lev, sort: gen output_indicator_lev = _n 
replace output_indicator_lev = 0 if output_indicator_lev != 1
drop if output_indicator_lev == 0 
keep quant_lev beta_by_lev vol_by_lev impvol_by_lev 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/lev.dta", replace
restore, preserve

*** then quintile sort for tierone 
drop if quant_tierone == . 
by quant_tierone, sort: gen output_indicator_tierone = _n 
replace output_indicator_tierone = 0 if output_indicator_tierone != 1
drop if output_indicator_tierone == 0 
keep quant_tierone beta_by_tierone vol_by_tierone impvol_by_tierone 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/tierone.dta", replace
restore, preserve

** then quintile sort by tce 
drop if quant_tce == . 
by quant_tce, sort: gen output_indicator_tce = _n 
replace output_indicator_tce = 0 if output_indicator_tce != 1
drop if output_indicator_tce == 0 
keep quant_tce beta_by_tce vol_by_tce impvol_by_tce 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/tce.dta", replace
restore, preserve

*** then we want to separately calculate up and down beta 
